// To parse this JSON data, do
//
//     final invoiceHistoryResponseModel = invoiceHistoryResponseModelFromJson(jsonString);

import 'dart:convert';

import '../auth/login/login_response_model.dart';

InvoiceHistoryResponseModel invoiceHistoryResponseModelFromJson(String str) => InvoiceHistoryResponseModel.fromJson(json.decode(str));

String invoiceHistoryResponseModelToJson(InvoiceHistoryResponseModel data) => json.encode(data.toJson());

class InvoiceHistoryResponseModel {
  String? remark;
  String? status;
  Message? message;
  Data? data;

  InvoiceHistoryResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory InvoiceHistoryResponseModel.fromJson(Map<String, dynamic> json) => InvoiceHistoryResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class Data {
  String? currentBalance;
  PaymentCharge? paymentCharge;
  Invoices? invoices;

  Data({
    this.currentBalance,
    this.paymentCharge,
    this.invoices,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        currentBalance: json["current_balance"],
        paymentCharge: json["payment_charge"] == null ? null : PaymentCharge.fromJson(json["payment_charge"]),
        invoices: json["invoices"] == null ? null : Invoices.fromJson(json["invoices"]),
      );

  Map<String, dynamic> toJson() => {
        "current_balance": currentBalance,
        "payment_charge": paymentCharge?.toJson(),
        "invoices": invoices?.toJson(),
      };
}

class Invoices {
  String? currentPage;
  List<InvoiceDataModel>? data;

  String? nextPageUrl;
  String? path;

  Invoices({
    this.currentPage,
    this.data,
    this.nextPageUrl,
    this.path,
  });

  factory Invoices.fromJson(Map<String, dynamic> json) => Invoices(
        currentPage: json["current_page"]?.toString(),
        data: json["data"] == null ? [] : List<InvoiceDataModel>.from(json["data"]!.map((x) => InvoiceDataModel.fromJson(x))),
        nextPageUrl: json["next_page_url"]?.toString(),
        path: json["path"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "current_page": currentPage,
        "data": data == null ? [] : List<dynamic>.from(data!.map((x) => x.toJson())),
        "next_page_url": nextPageUrl,
        "path": path,
      };
}

class InvoiceDataModel {
  int? id;
  String? uid;
  String? userId;
  String? merchantId;
  String? totalAmount;
  String? totalItem;
  String? cancelReason;
  String? status;
  String? createdAt;
  String? updatedAt;
  MerchantOrUserInfoModel? user;
  List<InvoiceItem>? invoiceItem;

  InvoiceDataModel({
    this.id,
    this.uid,
    this.userId,
    this.merchantId,
    this.totalAmount,
    this.totalItem,
    this.cancelReason,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.user,
    this.invoiceItem,
  });

  factory InvoiceDataModel.fromJson(Map<String, dynamic> json) => InvoiceDataModel(
        id: json["id"],
        uid: json["uid"]?.toString(),
        userId: json["user_id"]?.toString(),
        merchantId: json["merchant_id"]?.toString(),
        totalAmount: json["total_amount"]?.toString(),
        totalItem: json["total_item"]?.toString(),
        cancelReason: json["cancel_reason"]?.toString(),
        status: json["status"]?.toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
        user: json["user"] == null ? null : MerchantOrUserInfoModel.fromJson(json["user"]),
        invoiceItem: json["invoice_item"] == null ? [] : List<InvoiceItem>.from(json["invoice_item"]!.map((x) => InvoiceItem.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "uid": uid,
        "user_id": userId,
        "merchant_id": merchantId,
        "total_amount": totalAmount,
        "total_item": totalItem,
        "cancel_reason": cancelReason,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "user": user?.toJson(),
        "invoice_item": invoiceItem == null ? [] : List<dynamic>.from(invoiceItem!.map((x) => x.toJson())),
      };
}

class MerchantOrUserInfoModel {
  int? id;
  String? username;
  String? firstName;
  String? lastName;
  String? email;
  String? mobile;
  String? getImage;
  String? dialCode;

  MerchantOrUserInfoModel({
    this.id,
    this.username,
    this.firstName,
    this.lastName,
    this.email,
    this.mobile,
    this.getImage,
    this.dialCode,
  });

  factory MerchantOrUserInfoModel.fromJson(Map<String, dynamic> json) => MerchantOrUserInfoModel(
        id: json["id"],
        username: json["username"]?.toString(),
        firstName: json["firstname"]?.toString(),
        lastName: json["lastname"]?.toString(),
        email: json["email"]?.toString(),
        mobile: json["mobile"]?.toString(),
        getImage: json["get_image"]?.toString(),
        dialCode: json["dial_code"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "username": username,
        "firstname": firstName,
        "lastname": lastName,
        "email": email,
        "mobile": mobile,
        "get_image": getImage,
        "dial_code": dialCode,
      };

  // Method to get the name or fallback value
  String getDisplayName() {
    if ((firstName ?? '').isNotEmpty || (lastName ?? '').isNotEmpty) {
      return '${firstName ?? ''} ${lastName ?? ''}'.trim();
    }
    if ((username ?? '').isNotEmpty) {
      return username!;
    }
    return mobile ?? '';
  }

  String getPhoneNumber() {
    return "$dialCode$mobile";
  }
}

class InvoiceItem {
  int? id;
  String? invoiceId;
  String? name;
  String? price;
  String? createdAt;
  String? updatedAt;

  InvoiceItem({
    this.id,
    this.invoiceId,
    this.name,
    this.price,
    this.createdAt,
    this.updatedAt,
  });

  factory InvoiceItem.fromJson(Map<String, dynamic> json) => InvoiceItem(
        id: json["id"],
        invoiceId: json["invoice_id"]?.toString(),
        name: json["name"]?.toString(),
        price: json["price"]?.toString(),
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "invoice_id": invoiceId,
        "name": name,
        "price": price,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}

class PaymentCharge {
  int? id;
  String? slug;
  String? fixedCharge;
  String? percentCharge;
  String? minLimit;
  String? maxLimit;
  String? agentCommissionFixed;
  String? agentCommissionPercent;
  String? merchantPaymentFixedCharge;
  String? merchantPaymentPercentCharge;
  String? userPaymentPercentCharge;
  String? userPaymentFixedCharge;
  String? monthlyLimit;
  String? dailyLimit;
  String? dailyRequestAcceptLimit;
  String? monthlyRequestAcceptLimit;
  String? cap;
  int? voucherLimit;
  String? createdAt;
  String? updatedAt;

  PaymentCharge({
    this.id,
    this.slug,
    this.fixedCharge,
    this.percentCharge,
    this.minLimit,
    this.maxLimit,
    this.agentCommissionFixed,
    this.agentCommissionPercent,
    this.merchantPaymentFixedCharge,
    this.merchantPaymentPercentCharge,
    this.userPaymentPercentCharge,
    this.userPaymentFixedCharge,
    this.monthlyLimit,
    this.dailyLimit,
    this.dailyRequestAcceptLimit,
    this.monthlyRequestAcceptLimit,
    this.cap,
    this.voucherLimit,
    this.createdAt,
    this.updatedAt,
  });

  factory PaymentCharge.fromJson(Map<String, dynamic> json) => PaymentCharge(
        id: json["id"],
        slug: json["slug"]?.toString(),
        fixedCharge: json["fixed_charge"]?.toString(),
        percentCharge: json["percent_charge"]?.toString(),
        minLimit: json["min_limit"]?.toString(),
        maxLimit: json["max_limit"]?.toString(),
        agentCommissionFixed: json["agent_commission_fixed"]?.toString(),
        agentCommissionPercent: json["agent_commission_percent"]?.toString(),
        merchantPaymentFixedCharge: json["merchant_payment_fixed_charge"]?.toString(),
        merchantPaymentPercentCharge: json["merchant_payment_percent_charge"]?.toString(),
        userPaymentPercentCharge: json["user_payment_percent_charge"]?.toString(),
        userPaymentFixedCharge: json["user_payment_fixed_charge"]?.toString(),
        monthlyLimit: json["monthly_limit"]?.toString(),
        dailyLimit: json["daily_limit"]?.toString(),
        dailyRequestAcceptLimit: json["daily_request_accept_limit"]?.toString(),
        monthlyRequestAcceptLimit: json["monthly_request_accept_limit"]?.toString(),
        cap: json["cap"]?.toString(),
        voucherLimit: json["voucher_limit"],
        createdAt: json["created_at"]?.toString(),
        updatedAt: json["updated_at"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "slug": slug,
        "fixed_charge": fixedCharge,
        "percent_charge": percentCharge,
        "min_limit": minLimit,
        "max_limit": maxLimit,
        "agent_commission_fixed": agentCommissionFixed,
        "agent_commission_percent": agentCommissionPercent,
        "merchant_payment_fixed_charge": merchantPaymentFixedCharge,
        "merchant_payment_percent_charge": merchantPaymentPercentCharge,
        "user_payment_percent_charge": userPaymentPercentCharge,
        "user_payment_fixed_charge": userPaymentFixedCharge,
        "monthly_limit": monthlyLimit,
        "daily_limit": dailyLimit,
        "daily_request_accept_limit": dailyRequestAcceptLimit,
        "monthly_request_accept_limit": monthlyRequestAcceptLimit,
        "cap": cap,
        "voucher_limit": voucherLimit,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
